#include <stdafx.h>
#include "helper.h"

#include <math.h>
#include <time.h>

#include <fstream>
using namespace std;


double CalcAngle(const Point &p) {
	double w = 180.0 * atan2(p.m_y, p.m_x) / M_PI;
	while(w > 360.0) w -= 360.0;
	while(w < 0.0) w += 360.0;
	/*
	w = (long)(0.5 + w / 1.40625);
	w = w * 1.40625;
	*/
	return w;
}

double AngleDiff(double a1, double a2) {
	double diff = a1 - a2;
	if(diff > 180.0) {
		diff = 360.0 - diff;
	}
	else if(diff < -180.0) {
		diff = 360.0 + diff;
	}
	return diff;
}


Point::Point(double x, double y)
: m_x(x), m_y(y)
{
}


Line::Line(double x0, double y0, double x1, double y1)
: m_p0(x0, y0), m_r(x1 - x0, y1 - y0), m_n(-m_r.m_y, m_r.m_x), m_c(m_p0.m_x * m_n.m_x + m_p0.m_y * m_n.m_y)
{
}

Line::Line(const Point &p0, const Point &r) 
: m_p0(p0), m_r(r), m_n(-m_r.m_y, m_r.m_x), m_c(m_p0.m_x * m_n.m_x + m_p0.m_y * m_n.m_y)
{
}

void Line::lot(const Point &p2, Point &lotP) {
}

bool Line::intersection(const Line &l2, Point &interP) {
	bool bret = false;

	if( (m_n.m_y == 0.0) && (l2.m_n.m_y != 0.0) ) {
		interP.m_x = m_p0.m_x;
		interP.m_y = l2.m_c - (interP.m_x * l2.m_n.m_x / l2.m_n.m_y);
		bret = true;
	}
	else if( (l2.m_n.m_y == 0.0) && (m_n.m_y != 0.0) ) {
		interP.m_x = l2.m_p0.m_x;
		interP.m_y = m_c - (interP.m_x * m_n.m_x / m_n.m_y);
		bret = true;
	}
	else if( (l2.m_n.m_y != 0.0) && (m_n.m_y != 0.0) ) {
		double b = ( (l2.m_n.m_x / l2.m_n.m_y) - (m_n.m_x / m_n.m_y) );
		bret = (b != 0.0);
		if(bret) {
			double a = ( (l2.m_c / l2.m_n.m_y) - (m_c / m_n.m_y) );
			interP.m_x = a / b;
			interP.m_y = (m_c - interP.m_x * m_n.m_x) / m_n.m_y;
		}
	}
	return bret;
}

double Line::Factor(const Point &p) {
	double f1 = -9999.0;
	if(m_r.m_x != 0.0) {
		f1 = (p.m_x - m_p0.m_x) / m_r.m_x;
	}
	double f2 = -9999.0;
	if(m_r.m_x != 0.0) {
		f2 = (p.m_y - m_p0.m_y) / m_r.m_y;
	}

	if(fabs(f1 - f2) < 0.01) {
		return f1;
	}
	return -9999.0;
}



double MicroSecs::sm_usProFineTick = 0.0;
double MicroSecs::m_microSecs = 0;

void MicroSecs::InitTimer() {
	LARGE_INTEGER freq;
	if ( QueryPerformanceFrequency(&freq) != 0 ) {
		unsigned long fineTicksProSec = freq.u.LowPart;
		sm_usProFineTick = 1000000.0 / (double)fineTicksProSec;
	}
}

double MicroSecs::Now() {
	if(sm_usProFineTick == 0) InitTimer();

	LARGE_INTEGER t;
	QueryPerformanceCounter(&t);

	double dTick;
	dTick  = (double)((unsigned long)t.u.HighPart);
	dTick *= (double)0x10000;
	dTick *= (double)0x10000;
	dTick += (double)((unsigned long)t.u.LowPart);
	dTick *= sm_usProFineTick;                  /* Stundenraster */
	dTick = fmod (dTick, (double)(60.0 * 60.0 * 1000.0 * 1000.0));

	m_microSecs = dTick;
	return m_microSecs;
}



MyCriticalSection::MyCriticalSection() { 
	InitializeCriticalSection( GetCsPtr() ); 
}

MyCriticalSection::MyCriticalSection(const MyCriticalSection &) {
	InitializeCriticalSection( GetCsPtr() ); 
}

MyCriticalSection::~MyCriticalSection() { 
	DeleteCriticalSection( GetCsPtr() ); 
}

void MyCriticalSection::Acquire() { 
	EnterCriticalSection( GetCsPtr()); 
}

void MyCriticalSection::Release() { 
	LeaveCriticalSection( GetCsPtr()); 
}

MyCriticalSection* MyCriticalSection::CreateInstance(const string &name) {
  static map<string, MyCriticalSection*> csMap;
  map<string, MyCriticalSection*>:: iterator iter = csMap.find(name);
  if ( iter == csMap.end() ) {
    iter = csMap.insert( iter, make_pair(name, new MyCriticalSection()) );
  }
  return iter->second;
}


Statistics *Statistics::sm_Instance = NULL;
MyCriticalSection Statistics::sm_Lock;

Statistics::Statistics() {
	MyAutoLockCS al(m_DataLock);

	Reset();

	// init winkeltab
	BYTE b = 0;
	for(long i = 0; i < 256; ++i) {
		double w = (double)b * 360.0 / 256.0;
		while(w > 360.0) w -= 360.0;
		m_WinkelTab[w] = b;
		b += 3;
	}

    m_AngleLUT.push_back( make_pair(0, 0) );
    m_AngleLUT.push_back( make_pair(0, 3.62) );
    m_AngleLUT.push_back( make_pair(5, 8.64) );
    m_AngleLUT.push_back( make_pair(11, 12.45) );
    m_AngleLUT.push_back( make_pair(16, 16.84) );
    m_AngleLUT.push_back( make_pair(16, 20.73) );
    m_AngleLUT.push_back( make_pair(22, 25.28) );
    m_AngleLUT.push_back( make_pair(27, 29.84) );
    m_AngleLUT.push_back( make_pair(33, 33.69) );
    m_AngleLUT.push_back( make_pair(33, 37.3) );
    m_AngleLUT.push_back( make_pair(39, 41.39) );
    m_AngleLUT.push_back( make_pair(45, 46.02) );
    m_AngleLUT.push_back( make_pair(50, 50.66) );
    m_AngleLUT.push_back( make_pair(50, 55.3) );
    m_AngleLUT.push_back( make_pair(56, 59.53) );
    m_AngleLUT.push_back( make_pair(62, 63.43) );
    m_AngleLUT.push_back( make_pair(67, 67.38) );
    m_AngleLUT.push_back( make_pair(67, 71.57) );
    m_AngleLUT.push_back( make_pair(73, 75.96) );
    m_AngleLUT.push_back( make_pair(78, 79.7) );
    m_AngleLUT.push_back( make_pair(84, 84.22) );
    m_AngleLUT.push_back( make_pair(84, 89.27) );
    m_AngleLUT.push_back( make_pair(95, 92.9) );
    m_AngleLUT.push_back( make_pair(101, 97.21) );
    m_AngleLUT.push_back( make_pair(101, 101.74) );
    m_AngleLUT.push_back( make_pair(106, 105.45) );
    m_AngleLUT.push_back( make_pair(112, 110.47) );
    m_AngleLUT.push_back( make_pair(117, 113.96) );
    m_AngleLUT.push_back( make_pair(117, 117.86) );
    m_AngleLUT.push_back( make_pair(123, 123.09) );
    m_AngleLUT.push_back( make_pair(129, 126.87) );
    m_AngleLUT.push_back( make_pair(135, 130.91) );
    m_AngleLUT.push_back( make_pair(135, 135) );
    m_AngleLUT.push_back( make_pair(140, 139.09) );
    m_AngleLUT.push_back( make_pair(146, 143.13) );
    m_AngleLUT.push_back( make_pair(152, 147.69) );
    m_AngleLUT.push_back( make_pair(152, 152.14) );
    m_AngleLUT.push_back( make_pair(157, 156.04) );
    m_AngleLUT.push_back( make_pair(163, 160.88) );
    m_AngleLUT.push_back( make_pair(168, 164.55) );
    m_AngleLUT.push_back( make_pair(168, 169.25) );
    m_AngleLUT.push_back( make_pair(174, 172.79) );
    m_AngleLUT.push_back( make_pair(180, 177.14) );
    m_AngleLUT.push_back( make_pair(180, 182.15) );
    m_AngleLUT.push_back( make_pair(186, 185.78) );
    m_AngleLUT.push_back( make_pair(186, 190.05) );
    m_AngleLUT.push_back( make_pair(192, 194.56) );
    m_AngleLUT.push_back( make_pair(197, 198.21) );
    m_AngleLUT.push_back( make_pair(203, 203.38) );
    m_AngleLUT.push_back( make_pair(203, 206.56) );
    m_AngleLUT.push_back( make_pair(208, 211.09) );
    m_AngleLUT.push_back( make_pair(214, 215.29) );
    m_AngleLUT.push_back( make_pair(220, 220.45) );
    m_AngleLUT.push_back( make_pair(220, 223.98) );
    m_AngleLUT.push_back( make_pair(225, 227.53) );
    m_AngleLUT.push_back( make_pair(231, 232.7) );
    m_AngleLUT.push_back( make_pair(237, 235.71) );
    m_AngleLUT.push_back( make_pair(237, 240.25) );
    m_AngleLUT.push_back( make_pair(243, 244.72) );
    m_AngleLUT.push_back( make_pair(248, 249.27) );
    m_AngleLUT.push_back( make_pair(254, 252.47) );
    m_AngleLUT.push_back( make_pair(254, 257.55) );
    m_AngleLUT.push_back( make_pair(259, 261.36) );
    m_AngleLUT.push_back( make_pair(265, 265.71) );
    m_AngleLUT.push_back( make_pair(270, 270) );
    m_AngleLUT.push_back( make_pair(276, 273.58) );
    m_AngleLUT.push_back( make_pair(282, 278.64) );
    m_AngleLUT.push_back( make_pair(287, 282.45) );
    m_AngleLUT.push_back( make_pair(287, 286.84) );
    m_AngleLUT.push_back( make_pair(293, 290.73) );
    m_AngleLUT.push_back( make_pair(298, 295.28) );
    m_AngleLUT.push_back( make_pair(304, 299.12) );
    m_AngleLUT.push_back( make_pair(304, 303.69) );
    m_AngleLUT.push_back( make_pair(310, 307.3) );
    m_AngleLUT.push_back( make_pair(315, 311.39) );
    m_AngleLUT.push_back( make_pair(321, 316.02) );
    m_AngleLUT.push_back( make_pair(321, 319.55) );
    m_AngleLUT.push_back( make_pair(327, 324.71) );
    m_AngleLUT.push_back( make_pair(333, 328.91) );
    m_AngleLUT.push_back( make_pair(338, 332.78) );
    m_AngleLUT.push_back( make_pair(338, 336.04) );
    m_AngleLUT.push_back( make_pair(344, 341.57) );
    m_AngleLUT.push_back( make_pair(349, 345.26) );
    m_AngleLUT.push_back( make_pair(355, 349.7) );
    m_AngleLUT.push_back( make_pair(355, 354.22) );
    m_AngleLUT.push_back( make_pair(0, 357.83) );
    m_AngleLUT.push_back( make_pair(0, 2.9) );
    m_AngleLUT.push_back( make_pair(5, 7.21) );
    m_AngleLUT.push_back( make_pair(11, 11.02) );
    m_AngleLUT.push_back( make_pair(11, 15.45) );
    m_AngleLUT.push_back( make_pair(16, 19.12) );
    m_AngleLUT.push_back( make_pair(22, 23.96) );
    m_AngleLUT.push_back( make_pair(27, 27.86) );
    m_AngleLUT.push_back( make_pair(27, 33.08) );
    m_AngleLUT.push_back( make_pair(33, 36.87) );
    m_AngleLUT.push_back( make_pair(39, 40.91) );
    m_AngleLUT.push_back( make_pair(45, 45) );
    m_AngleLUT.push_back( make_pair(45, 49.09) );
    m_AngleLUT.push_back( make_pair(50, 53.13) );
    m_AngleLUT.push_back( make_pair(56, 56.92) );
    m_AngleLUT.push_back( make_pair(62, 62.14) );
    m_AngleLUT.push_back( make_pair(62, 66.04) );
    m_AngleLUT.push_back( make_pair(67, 70.88) );
    m_AngleLUT.push_back( make_pair(73, 74.55) );
    m_AngleLUT.push_back( make_pair(78, 78.98) );
    m_AngleLUT.push_back( make_pair(78, 82.79) );
    m_AngleLUT.push_back( make_pair(84, 87.1) );
    m_AngleLUT.push_back( make_pair(95, 92.17) );
    m_AngleLUT.push_back( make_pair(95, 95.78) );
    m_AngleLUT.push_back( make_pair(101, 100.31) );
    m_AngleLUT.push_back( make_pair(106, 104.74) );
    m_AngleLUT.push_back( make_pair(112, 108.44) );
    m_AngleLUT.push_back( make_pair(112, 113.96) );
    m_AngleLUT.push_back( make_pair(117, 117.22) );
    m_AngleLUT.push_back( make_pair(123, 121.09) );
    m_AngleLUT.push_back( make_pair(129, 125.29) );
    m_AngleLUT.push_back( make_pair(129, 130.45) );
    m_AngleLUT.push_back( make_pair(135, 133.98) );
    m_AngleLUT.push_back( make_pair(140, 138.61) );
    m_AngleLUT.push_back( make_pair(146, 142.7) );
    m_AngleLUT.push_back( make_pair(146, 146.31) );
    m_AngleLUT.push_back( make_pair(152, 150.88) );
    m_AngleLUT.push_back( make_pair(157, 154.72) );
    m_AngleLUT.push_back( make_pair(163, 159.27) );
    m_AngleLUT.push_back( make_pair(163, 163.16) );
    m_AngleLUT.push_back( make_pair(168, 167.55) );
    m_AngleLUT.push_back( make_pair(174, 171.36) );
    m_AngleLUT.push_back( make_pair(180, 176.42) );
    m_AngleLUT.push_back( make_pair(180, 180) );
    m_AngleLUT.push_back( make_pair(180, 184.29) );
    m_AngleLUT.push_back( make_pair(186, 188.64) );
    m_AngleLUT.push_back( make_pair(192, 192.45) );
    m_AngleLUT.push_back( make_pair(197, 197.53) );
    m_AngleLUT.push_back( make_pair(197, 200.73) );
    m_AngleLUT.push_back( make_pair(203, 205.28) );
    m_AngleLUT.push_back( make_pair(208, 209.74) );
    m_AngleLUT.push_back( make_pair(214, 214.29) );
    m_AngleLUT.push_back( make_pair(214, 217.3) );
    m_AngleLUT.push_back( make_pair(220, 222.47) );
    m_AngleLUT.push_back( make_pair(225, 226.02) );
    m_AngleLUT.push_back( make_pair(231, 229.55) );
    m_AngleLUT.push_back( make_pair(231, 234.71) );
    m_AngleLUT.push_back( make_pair(237, 238.91) );
    m_AngleLUT.push_back( make_pair(243, 243.43) );
    m_AngleLUT.push_back( make_pair(248, 246.61) );
    m_AngleLUT.push_back( make_pair(248, 251.79) );
    m_AngleLUT.push_back( make_pair(254, 255.44) );
    m_AngleLUT.push_back( make_pair(259, 259.95) );
    m_AngleLUT.push_back( make_pair(265, 264.22) );
    m_AngleLUT.push_back( make_pair(265, 267.85) );
    m_AngleLUT.push_back( make_pair(276, 272.86) );
    m_AngleLUT.push_back( make_pair(282, 277.21) );
    m_AngleLUT.push_back( make_pair(282, 280.75) );
    m_AngleLUT.push_back( make_pair(287, 285.45) );
    m_AngleLUT.push_back( make_pair(293, 289.12) );
    m_AngleLUT.push_back( make_pair(298, 293.96) );
    m_AngleLUT.push_back( make_pair(298, 297.86) );
    m_AngleLUT.push_back( make_pair(304, 302.31) );
    m_AngleLUT.push_back( make_pair(310, 306.87) );
    m_AngleLUT.push_back( make_pair(315, 310.91) );
    m_AngleLUT.push_back( make_pair(315, 315) );
    m_AngleLUT.push_back( make_pair(321, 319.09) );
    m_AngleLUT.push_back( make_pair(327, 323.13) );
    m_AngleLUT.push_back( make_pair(333, 326.92) );
    m_AngleLUT.push_back( make_pair(333, 332.14) );
    m_AngleLUT.push_back( make_pair(338, 336.04) );
    m_AngleLUT.push_back( make_pair(344, 339.53) );
    m_AngleLUT.push_back( make_pair(349, 344.55) );
    m_AngleLUT.push_back( make_pair(349, 348.26) );
    m_AngleLUT.push_back( make_pair(355, 352.79) );
    m_AngleLUT.push_back( make_pair(0, 357.1) );
    m_AngleLUT.push_back( make_pair(0, 0.73) );
    m_AngleLUT.push_back( make_pair(5, 5.78) );
    m_AngleLUT.push_back( make_pair(5, 10.3) );
    m_AngleLUT.push_back( make_pair(11, 14.04) );
    m_AngleLUT.push_back( make_pair(16, 18.43) );
    m_AngleLUT.push_back( make_pair(22, 22.62) );
    m_AngleLUT.push_back( make_pair(22, 26.57) );
    m_AngleLUT.push_back( make_pair(27, 30.47) );
    m_AngleLUT.push_back( make_pair(33, 34.7) );
    m_AngleLUT.push_back( make_pair(39, 39.34) );
    m_AngleLUT.push_back( make_pair(39, 43.98) );
    m_AngleLUT.push_back( make_pair(45, 48.61) );
    m_AngleLUT.push_back( make_pair(50, 52.7) );
    m_AngleLUT.push_back( make_pair(56, 56.31) );
    m_AngleLUT.push_back( make_pair(56, 60.16) );
    m_AngleLUT.push_back( make_pair(62, 64.72) );
    m_AngleLUT.push_back( make_pair(67, 69.27) );
    m_AngleLUT.push_back( make_pair(73, 73.16) );
    m_AngleLUT.push_back( make_pair(73, 77.55) );
    m_AngleLUT.push_back( make_pair(78, 81.36) );
    m_AngleLUT.push_back( make_pair(84, 86.38) );
    m_AngleLUT.push_back( make_pair(90, 90) );
    m_AngleLUT.push_back( make_pair(95, 94.34) );
    m_AngleLUT.push_back( make_pair(101, 98.64) );
    m_AngleLUT.push_back( make_pair(106, 102.45) );
    m_AngleLUT.push_back( make_pair(106, 107.53) );
    m_AngleLUT.push_back( make_pair(112, 110.73) );
    m_AngleLUT.push_back( make_pair(117, 115.28) );
    m_AngleLUT.push_back( make_pair(123, 120.47) );
    m_AngleLUT.push_back( make_pair(123, 124.29) );
    m_AngleLUT.push_back( make_pair(129, 127.3) );
    m_AngleLUT.push_back( make_pair(135, 132.47) );
    m_AngleLUT.push_back( make_pair(140, 136.02) );
    m_AngleLUT.push_back( make_pair(140, 140.66) );
    m_AngleLUT.push_back( make_pair(146, 145.31) );
    m_AngleLUT.push_back( make_pair(152, 149.53) );
    m_AngleLUT.push_back( make_pair(157, 154.08) );
    m_AngleLUT.push_back( make_pair(157, 157.93) );
    m_AngleLUT.push_back( make_pair(163, 161.79) );
    m_AngleLUT.push_back( make_pair(168, 166.14) );
    m_AngleLUT.push_back( make_pair(174, 169.95) );
    m_AngleLUT.push_back( make_pair(174, 174.22) );
    m_AngleLUT.push_back( make_pair(180, 179.28) );
    m_AngleLUT.push_back( make_pair(180, 182.86) );
    m_AngleLUT.push_back( make_pair(186, 187.21) );
    m_AngleLUT.push_back( make_pair(192, 191.45) );
    m_AngleLUT.push_back( make_pair(192, 195.45) );
    m_AngleLUT.push_back( make_pair(197, 200.47) );
    m_AngleLUT.push_back( make_pair(203, 203.96) );
    m_AngleLUT.push_back( make_pair(208, 207.86) );
    m_AngleLUT.push_back( make_pair(208, 212.31) );
    m_AngleLUT.push_back( make_pair(214, 216.87) );
    m_AngleLUT.push_back( make_pair(220, 220.91) );
    m_AngleLUT.push_back( make_pair(225, 225) );
    m_AngleLUT.push_back( make_pair(225, 229.09) );
    m_AngleLUT.push_back( make_pair(231, 233.13) );
    m_AngleLUT.push_back( make_pair(237, 237.69) );
    m_AngleLUT.push_back( make_pair(243, 242.14) );
    m_AngleLUT.push_back( make_pair(243, 246.04) );
    m_AngleLUT.push_back( make_pair(248, 249.53) );
    m_AngleLUT.push_back( make_pair(254, 254.55) );
    m_AngleLUT.push_back( make_pair(259, 258.55) );
    m_AngleLUT.push_back( make_pair(259, 262.79) );
    m_AngleLUT.push_back( make_pair(265, 267.14) );
    m_AngleLUT.push_back( make_pair(276, 270.72) );
    m_AngleLUT.push_back( make_pair(276, 275.78) );
    m_AngleLUT.push_back( make_pair(282, 280.05) );
    m_AngleLUT.push_back( make_pair(287, 283.86) );
    m_AngleLUT.push_back( make_pair(293, 288.21) );
    m_AngleLUT.push_back( make_pair(293, 292.07) );
    m_AngleLUT.push_back( make_pair(298, 295.92) );
    m_AngleLUT.push_back( make_pair(304, 300.47) );
    m_AngleLUT.push_back( make_pair(310, 304.7) );
    m_AngleLUT.push_back( make_pair(310, 309.34) );
    m_AngleLUT.push_back( make_pair(315, 313.98) );
    m_AngleLUT.push_back( make_pair(321, 317.53) );
    m_AngleLUT.push_back( make_pair(327, 322.7) );
    m_AngleLUT.push_back( make_pair(327, 325.71) );
    m_AngleLUT.push_back( make_pair(333, 329.53) );
    m_AngleLUT.push_back( make_pair(338, 334.72) );
    m_AngleLUT.push_back( make_pair(344, 339.27) );
    m_AngleLUT.push_back( make_pair(344, 342.47) );
    m_AngleLUT.push_back( make_pair(349, 347.55) );
    m_AngleLUT.push_back( make_pair(355, 351.36) );
    m_AngleLUT.push_back( make_pair(0, 355.66) );
}

Statistics* Statistics::GetStatistics() {
	MyAutoLockCS al(sm_Lock);
	if(sm_Instance == NULL) {
		sm_Instance = new Statistics();
	}
	return sm_Instance;
}

void Statistics::Reset() {
	MyAutoLockCS al(m_DataLock);

	m_SHOT_SPEED = 8.0;
	m_ViewIndexHisto.clear();
	m_LastTargets.clear();
	for(long i = 0; i < 20; ++i) {
		m_ViewIndexHisto.push_back(0);
		m_LastTargets.push_back( pair<unsigned int, double>(-1, 0) );
	}

	m_LastMoves.clear();
	m_LastViewAngles.clear();
	for(long i = 0; i < 10; ++i) {
		m_LastMoves.push_back( MoveHisto() );
		m_LastViewAngles.push_back(0);
	}
    m_MissingMoves = m_MissingFrames = 0;

	m_GameRunning = false;
	m_100K = m_Score = 0;
	m_CurrentLevel = -1;
	m_Levels.clear();
	m_Levels.reserve(25);
}

void Statistics::SaveStatistics() {
    /*
	MyAutoLockCS al(m_DataLock);
	char fileName[512], tmpbuf[128];

	_strtime_s( tmpbuf, 128 );
    {
        ofstream os1(".\\GameLogs\\moni_overview.txt", ios::out | ios::app);
        os1 << tmpbuf << "\t" << m_100K + m_Score << "\n";
    }

	for(unsigned long i = 0; i < strlen(tmpbuf); ++i) {
		if(tmpbuf[i] == ':') tmpbuf[i] = '_';
	}
	sprintf_s(fileName, 512, ".\\GameLogs\\moni_%s.txt", tmpbuf);
	ofstream os(fileName, ios::out);

	os << "Score:\t" << m_100K + m_Score << "\n";
	os << "Level\tFrames\tScore\tLScore\tUFO\tsmall\tmedium\tbig\t4xFF\t4xFF+hit\n";
	long prevPoints = 0;
	for(unsigned long i = 0; i < m_Levels.size(); ++i) {
		LevelData &data = m_Levels[i];
		os << i << "\t";
		os << data.m_Frames << "\t";
		os << data.m_Points << "\t";
		os << data.m_Points - prevPoints << "\t";
		os << data.m_NumUFO << "\t";
		os << data.m_NumAstros[ASTERIOD_SMALL] << "\t";
		os << data.m_NumAstros[ASTERIOD_MEDIUM] << "\t";
		os << data.m_NumAstros[ASTERIOD_BIG] << "\t";
        os << data.m_Check_NumFFCount << "\t" << data.m_Check_NumFFSuccess;
        os << "\n";
		prevPoints = data.m_Points;
	}
    */
}
